<?php 

$url = 'https://10.141.11.14:22633/';
// include pdf libraries
require(APPPATH.'/libraries/lib_pdf/fpdf/fpdf.php');

class PDF extends fpdf
{
	var $width_col_r = 220;
	//Page header
	

	//********************************* STYLES ******************************************
	
	function coloredHeaderCell($text,$x,$y,$length = false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',7);
		$this->SetTextColor(255, 255, 255);
		$this->SetFillColor(95,95,95);
		if(!$length){
		$length = 261;
		}
		$this->Cell($length,10,$text,0,0,'C',1);
	}
	
		function boldText($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','B',8);
		$this->SetTextColor(0, 0, 0);
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(100,10,$text,'',$allign);	
	}		
	
		function normalText($text,$x,$y,$allign=false){
		$this->SetXY($x,$y);
		$this->SetFont('Arial','',7);
		$this->SetTextColor(0, 0, 0);
		
		if(!$allign){
		$allign = 'L';;
		}
		$this->MultiCell(110,10,$text,'',$allign);
	}		
	
		function normalText2($text,$x,$y,$allign=false){
			$this->SetXY($x,$y);
			$this->SetFont('Arial','',7);
			$this->SetTextColor(0, 0, 0);
			
			if(!$allign){
			$allign = 'L';;
			}
			$this->MultiCell(155,10,$text,'',$allign);
		}		
	
		function normalText3($text,$x,$y,$allign=false){
				$this->SetXY($x,$y);
				$this->SetFont('Arial','',6);
				$this->SetTextColor(0, 0, 0);
				
				if(!$allign){
				$allign = 'L';;
				}
				$this->MultiCell(261,10,$text,'',$allign);
			}		
	
		function normalText4($text,$x,$y,$allign=false){
				$this->SetXY($x,$y);
				$this->SetFont('Arial','',6);
				$this->SetTextColor(0, 0, 0);
				
				if(!$allign){
				$allign = 'L';;
				}
				$this->MultiCell(300,9,$text,'',$allign);
			}		
	
			function normalText4B($text,$x,$y,$allign=false){
				$this->SetXY($x,$y);
				$this->SetFont('Arial','B',6);
				$this->SetTextColor(0, 0, 0);
				
				if(!$allign){
				$allign = 'L';;
				}
				$this->MultiCell(300,9,$text,'',$allign);
			}	
	
		function normalText5($text,$x,$y,$allign=false){
				$this->SetXY($x,$y);
				$this->SetFont('Arial','BI',6);
				$this->SetTextColor(0, 0, 0);
				
				if(!$allign){
				$allign = 'L';;
				}
				$this->MultiCell(230,9,$text,'',$allign);
			}	
	
	
	//*************************************************************************************

	function Header()
	{

	// voucher
	$this->SetTextColor(95, 95, 95);
	$this->SetXY(165,37);
	$this->SetFont('Arial','B',25);
	$this->Cell(100,20,'CLAIM TICKET VOUCHER',0,0,'C');
	
	//Logo

	$this->Image('resources/images/logo.jpg',480,10,100);
	
	
	
	}
	
	//Page footer
	function Footer()
	{
		//Position at 1.5 cm from bottom
		$this->SetY(-15);
		//Arial italic 8
		$this->SetFont('Arial','I',8);
		//Page number
		$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
	}


}

//Instantiation of inherited class
$pdf=new PDF('P', 'pt', 'Letter');





$pdf->SetMargins(10, 10);
$pdf->AliasNbPages();
$pdf->SetDrawColor(183, 183, 183);
$pdf->SetFont('Times','',12);
$pdf->SetAutoPageBreak(true,0);
$in = 72; // inch
$right_panel_width = 440;
$left_panel_width = 180;
$line_text_margin = 0;
$logo_height = 25;
$logo_width = 0;
$logo_count = 0;
$logo_margin = 5;
$text_margin = 2;
$left_container_width = 88;
$left_text_margin = 0;
		

// transaction barcode
$barcode_hash = hash("crc32", $transaction->transaction_id);
$barcode_hash = strtoupper($barcode_hash);
$transaction_barcode = $url.'smtAPI/call.php/resources/barcode/barcode.php?text='.$barcode_hash;
	
// add barcode to transactions table
$this->transactions->add_barcode($transaction->transaction_id, $barcode_hash);
$pdf->AddPage();

		$pdf->ColoredHeaderCell('ACCOUNT DETAILS',30,65);	
	
		//USER ID
		$pdf->boldText('USER ID',30, 80);
			$pdf->normalText2($transaction->username,130,80);
		
		//ACCOUNT NAME
		$pdf->boldText('ACCOUNT NAME',30, 90);
			$pdf->normalText2(strtoupper($transaction->customer_firstname . ' ' .  $transaction->customer_lastname),130,90);
			
		//ADDRESS
		$pdf->boldText('ADDRESS',30,100);
			$pdf->normalText2($transaction->customer_address1,130,100);
			
			
		//E-MAIL ADRESS
		$pdf->boldText('E-MAIL ADRESS',30,120);
			$pdf->normalText2($transaction->customer_email,130,120);

		
		//MOBILE NUMBER
		$pdf->boldText('MOBILE NUMBER',30,130);
			$pdf->normalText2($transaction->customer_mobile,130,130);
			
			
			
		//CREDIT CARD NAME
		$pdf->boldText('CREDIT CARD NAME',30,140);
			
		
		
		//CREDIT CARD NUMBER
		$credit_card_number = $transaction->card_number_value;
		if(!$credit_card_number){
		$credit_card_number = 'n/a';
		}
		$pdf->boldText('CREDIT CARD NUMBER',30,150);
			$pdf->normalText2($credit_card_number,130,150);
	
	
		$pdf->ColoredHeaderCell('EVENT DETAILS',321,65);	
		
		//EVENT TITLE
		$pdf->boldText('EVENT TITLE',321, 80);
			$pdf->normalText2($event->event_title,390,80);
		
		//EVENT DATE TIME
		$pdf->boldText('DATE/TIME',321, 100);
		
		$date = new DateTime($event->event_date_time);
			$pdf->normalText2($date->format('d-F-Y h:i a'),390,100);
		
		
		//VENUE
		$pdf->boldText('VENUE',321,110);
			$pdf->normalText2($event->venue_name,390,110);
			
		
		//DATE/TIME TRANSACTION
		$pdf->boldText('DATE/TIME TRANSACTED',321,130);
		
		$date = new DateTime($transaction->transaction_date);
			$pdf->normalText2($date->format('d-F-Y h:i a'),390,140);

		
		//STATUS / PAYMENT TYPE
		$pdf->boldText('STATUS',321,150);
			$pdf->normalText2($payment_type,390,150);
			
		

		$pdf->Line(30, 160, 582, 160);	
		
		$pdf->ColoredHeaderCell('TICKET DETAILS',30,162,552); 
		
	//****************************/	TICKET DETAILS	/**********************************************************
	
		$pdf->boldText('PRICE CATEGORY',30,175,'C');
		
		$pdf->boldText('TICKET ID',123,175,'C');
		

		
		$pdf->boldText('TICKET PRICE',208,175,'C');
		
		$pdf->boldText('SECTION CODE',295,175,'C');
		
		$pdf->boldText('SEAT TYPE',370,175,'C');
		
		$pdf->boldText('ROW',432,175,'C');
		
		$pdf->boldText('SEAT',492,175,'C');
				
				
			$y = 185;

			foreach ($tickets as $ticket)
			{
				$pdf->normalText($ticket->price_name,30,$y,'C');

				$pdf->normalText($ticket->ticket_id,116,$y,'C');
				
				$pdf->normalText('P ' . number_format($ticket->price_price, 2),198,$y,'C');
				
				$pdf->normalText($ticket->section_code,280,$y,'C');
				
				$ticket_seat = $ticket->ticket_seat;
				
				if($ticket_seat ==  "Free Seating" || $ticket_seat ==  "Standing"){
				$ticket_seat = $ticket->ticket_seat;
				}else{				
				$ticket_seat = "Reserved";
				}
				
				$pdf->normalText($ticket_seat,360,$y,'C');
				
				$ticket_row = trim($ticket->ticket_row);
				if(!$ticket_row){
				$ticket_row = "N/A";
				}
				
				$pdf->normalText($ticket_row,425,$y,'C');

				$pdf->normalText($ticket->ticket_seat,485,$y,'C');
	


				$y = $y + 9;
			}

		$y = $y + 3;



		$long_text = "\n This is not yet your actual ticket to the venue. Please print and bring this CLAIM TICKET VOUCHER to any SM TICKETS outlets located in all SM CINEMA nationwide to redeem your actual ticket. It is your responsibility to protect your voucher. Redemption can only be done ONCE. Any succeeding attempt will not be accepted by the system. \n \n";
		
		$pdf->SetXY(30,$y);
		$pdf->SetFont('Arial','',9);
		$pdf->SetTextColor(255, 255, 255);
		$pdf->SetFillColor(204, 51, 51);
		$pdf->MultiCell(552,9,$long_text,'','C',1);
	
	//****************************/	TRANSACTION DETAILS	/**********************************************************
	
		$y = $y + 48;
		$pdf->ColoredHeaderCell('TRANSACTION DETAILS',30,$y,552); 
		
		$y = $y + 15;
		
		$pdf->boldText('QUANTITY',30,$y,'C');		
		
		
		$pdf->boldText('PRICE CATEGORY',140,$y,'L');
	
		$pdf->boldText('TICKET PRICE',240,$y,'R');
		
		$pdf->boldText('AMOUNT',400,$y,'R');
	
		$y = $y + 10;
		foreach ($tickets as $ticket)
		{


		$ticket_count = count($tickets);
		$price_name = $ticket->price_name;
		$price = $ticket->price_price;
		$amount = $ticket->price_price * $ticket_count;
		$online_fee_total = $event->event_internet_sales_charge * $ticket_count;
		//Quantity
		$pdf->normalText($ticket_count,30,$y,'C');
		
		//Price Category
		$pdf->normalText($price_name,140,$y,'L');
		
		//Ticket Price
		$pdf->normalText('P ' . number_format($price, 2),230,$y,'R');
		
		//Amount
		$pdf->normalText('P ' . number_format($amount, 2),390,$y,'R');
		}
		$y = $y + 10;
		

				//Ticket Price
				$pdf->boldText('SUB-TOTAL',240,$y,'R');
				
				//Amount
				$pdf->normalText('P ' . number_format($amount, 2),390,$y,'R');
				
		$y = $y + 10;		
		
				//Quantity
				$pdf->normalText($ticket_count,30,$y,'C');
				
				//Online Fee
				$pdf->normalText('ONLINE FEE',140,$y,'L');
		
				//Online Fee
				$pdf->normalText('P ' . number_format($event->event_internet_sales_charge + 0, 2) ,230,$y,'R');
				
				//Online Fee Total
				$pdf->normalText('P ' . number_format($online_fee_total, 2) ,390,$y,'R');
		
		$y = $y + 10;	
						
				//GRAND TOTAL
				$pdf->boldText('GRAND TOTAL',350,$y,'R');
				
				//GRAND TOTAL AMOUNT
				$pdf->boldText('P ' . number_format(($ticket->price_price * $ticket_count) + ($event->event_internet_sales_charge * $ticket_count), 2) ,400,$y,'R');
		
	//*******************************************************************************************************************************************************************

	$yy = $y;
		$y = $y + 15;	
	$pdf->ColoredHeaderCell('ACNOWLEDGEMENT RECEIPT',30,$y);	
	
	$pdf->ColoredHeaderCell('OFFICIAL RECEIPT',321,$y);
			
			$y = $y + 10;	
				$pdf->normalText3('SM PRIME HOLDINGS, INC.' ,30,$y,'C');
				$pdf->normalText3('SM PRIME HOLDINGS, INC.' ,321,$y,'C');
				
			$y = $y + 6;		
				$pdf->normalText3('11F Mall Of Asia Arena Annex Building' ,30,$y,'C');	
				$pdf->normalText3('11F Mall Of Asia Arena Annex Building' ,321,$y,'C');	
				
			$y = $y + 6;		
				$pdf->normalText3('Coral Way corner J.W. Diokno Boulevard, Mall Of Asia Complex,' ,30,$y,'C');
				$pdf->normalText3('Coral Way corner J.W. Diokno Boulevard, Mall Of Asia Complex,' ,321,$y,'C');
				
			$y = $y + 6;		
				$pdf->normalText3('Brgy. 076 Zone 10, Pasay City' ,30,$y,'C');
				$pdf->normalText3('Brgy. 076 Zone 10, Pasay City' ,321,$y,'C');
				
			$y = $y + 6;		
				$pdf->normalText3('TEL 4702222 FAX 8632844 | www.smtickets.com' ,30,$y,'C');	
				$pdf->normalText3('TEL 4702222 FAX 8632844 | www.smtickets.com' ,321,$y,'C');	
				
			$y = $y + 6;		
				$pdf->normalText3('TIN 003-058-789-041 VAT"' ,30,$y,'C');
				$pdf->normalText3('TIN 003-058-789-041 VAT"' ,321,$y,'C');

	//*******************************************************************************************************************************************************************
			$y = $y + 10;
			$pdf->ColoredHeaderCell($price_name,30,$y);	
			$pdf->ColoredHeaderCell('ONLINE FEE',321,$y);
			
			$y = $y + 20;	
				$pdf->boldText('QUANTITY',40,$y,'L');
				$pdf->boldText('TICKET PRICE',115,$y,'L');
				$pdf->boldText('AMOUNT',220,$y,'L');
				
				$pdf->boldText('QUANTITY',331,$y,'L');
				$pdf->boldText('TICKET PRICE',407,$y,'L');
				$pdf->boldText('AMOUNT',511,$y,'L');
				
			$y = $y + 15;		
				$pdf->normalText2($ticket_count,60,$y,'L');
				$pdf->normalText2('P ' . number_format($price, 2),1,$y,'R');
				$pdf->normalText2('P ' . number_format($amount, 2),83,$y,'R');

				$pdf->normalText2($ticket_count,351,$y,'L');
				$pdf->normalText2('P ' . number_format($event->event_internet_sales_charge + 0, 2),295,$y,'R');
				$pdf->normalText2('P ' . number_format($online_fee_total, 2),373,$y,'R');
			
			$y = $y + 10;	
			$acknowledgement_receipt = ($ticket->ticket_acknowledgment_receipt) ? sprintf("%06d", $ticket->ticket_acknowledgment_receipt) : 0;
			
				

			$pdf->normalText3('ACKNOWLEDGEMENT RECEIPT NUMBER ' . $acknowledgement_receipt,30,$y,'C');
			// $pdf->normalText3('OFFICIAL RECEIPT NUMBER ' . $acknowledgement_receipt,60,$y,'L');
			
			$or_number = ($transaction->transaction_receipt_number) ? sprintf("%06d", $transaction->transaction_receipt_number) : 0;
			$dform = $transaction->transaction_date;
			$pdf->normalText2("OFFICIAL RECEIPT NO $or_number",385,$y,'L');
	

			$y = $y + 10;	
			
			$pdf->SetXY(90,$y);
			$pdf->SetFont('Arial','',12);
			$pdf->MultiCell(170,10,'TRANSACTION ID ' . $transaction->transaction_id,'','L');
			
			$pdf->SetXY(373,$y);
			$pdf->MultiCell(170,10,'TRANSACTION ID ' . $transaction->transaction_id,'','L');

			
			$y = $y + 10;	
			// $pdf->normalText2($transaction->transaction_date,300,$y,'L');
			$pdf->normalText2($transaction->transaction_date . " \n THIS SERVES AS YOUR OFFICIAL RECEIPT",370,$y,'C');
			
			// $y = $y + 5;	
			
			$pdf->SetXY(15,$y);
			$pdf->MultiCell(300,10,'THIS SERVES AS YOUR PROOF OF PAYMENT','','C');
			
			$y = $y + 10;	
			
			$pdf->SetXY(20,$y);
			$pdf->MultiCell(300,10,'TICKET REDEMPTION CODE','','C');
			
			
			//BARCODE------------------

		
			
			$barcode_hash = hash("crc32", $transaction->transaction_id);
			$barcode_hash = strtoupper($barcode_hash);
			$transaction_barcode = $url.'resources/barcode/barcode.php?text='.$barcode_hash;
				
			// add barcode to transactions table
			$this->transactions->add_barcode($transaction->transaction_id, $barcode_hash);
						
				if ($voucher_type == 'all')
				{
					
					$pdf->Image($transaction_barcode, 102, $y+10, 0, 30, 'PNG');
					$y = $y + 45;	
					$pdf->SetXY(135,$y);
					$pdf->SetFont('Arial','',12);
					$pdf->MultiCell(300,10,$barcode_hash ,'','L');
				}
			
			if ($voucher_type == 'one')
				{

					// ticket code	
					$barcode_hash = hash("crc32", $ticket->ticket_id);
					$barcode_hash = strtoupper($barcode_hash);
					$barcode = $url.'resources/barcode/barcode.php?text='.$barcode_hash;
		
					// bar code image
					$pdf->Image($barcode, 102, $y+10, 0, 30, 'PNG');
					
					// add barcode to tickets table
					$this->tickets->add_barcode($ticket->ticket_id, $barcode_hash);
				}


			$y = $y + 15;	
			// $y = 556;
		
			$pdf->ColoredHeaderCell("NOTICE TO ONLINE CUSTOMER",30,$y,552); 
			$y = $y + 10;
			$pdf->ColoredHeaderCell("ONLINE TICKET PURCHASED - REDEMPTION PROCESS",30,$y,552); 

			$y = $y + 15;	
			$yy = $y;
			
			$pdf->normalText4("Only the credit card owner who purchased the ticket online will be allowed to redeem ticket \nwith the following requirement" ,30,$y,'L');

						
			$y = $y + 24;	
			$pdf->normalText4B("a. Online user account name must be the same with the credit card used and presented \n    during redemption" ,30,$y,'L');

			// $pdf->normalText4B("If REGISTERED ACCOUNT IS THE SAME THAT APPEARS ON THE CREDIT CARD NUMBER PRINTED ON THE CLAIM TICKET VOUCHER" ,30,$y,'L');
			
			$y = $y + 24;	
			$pdf->normalText4("b.  Additional valid government ID must be presented" ,30,$y,'L');
			
			$y = $y + 12;	
			$pdf->normalText4("c.  Physical credit card used must be presented" ,30,$y,'L');
				
			$y = $y + 12;	
			$pdf->normalText4("d.  Name on the credit card must be the same as the online user account created in our website" ,30,$y,'L');

			
			$y = $y + 12;	
			$pdf->normalText4("e.  Credit card number must be the same as indicated in the claim ticket voucher",30,$y,'L');

			
			$y = $y + 12;	
			$pdf->normalText4("Thank you for your continued patronage!" ,30,$y,'L');
			
		



			//*************************************************************************************************************************




			$y = $yy;	
			$pdf->normalText5("CARDHOLDER shall assume full and exclusive responsibility for, and defend, indemnify and hold SM TICKETS completely free and harmless from any claim, dispute, suit or action for any and all losses /damage, arising from any cause/reason whatsoever, and sustained or suffered before, during and after this PURCHASE." ,350,$y,'C');
			
			$y = $y + 70;	
			
				$pdf->SetLineWidth(1);
				$pdf->SetDrawColor(0,0,0);
				$pdf->Line(360, $y, 460, $y);	
				$pdf->Line(480, $y, 570, $y);	
		
			$pdf->normalText4B("CARDHOLDER NAME/SIGNATURE" ,360,$y,'L');
			$pdf->normalText4B("DATE" ,520,$y,'L');
			
			
			$y = $y + 20;
			$pdf->normalText4B("TYPE OF ID PRESENTED" ,360,$y,'L');
			$pdf->Line(440, $y+6, 550, $y+6);
			
			$y = $y + 10;
			$pdf->normalText4B("ID NUMBER" ,360,$y,'L');
			$pdf->Line(440, $y+6, 550, $y+6);
			
			
			$y = $y + 15;	
			$pdf->ColoredHeaderCell("VISIT ANY SM TICKETS OUTLETS LOCATED IN ALL SM CINEMAS NATIONWIDE TO CLAIM YOUR ACTUAL TICKE TO THE EVENT",30,$y,552); 
			$y = $y + 10;
			$pdf->ColoredHeaderCell("FOR INQUIRIES AND ASSISTANCE, PLEASE CALL 02-470 2222 OR EMAIL US AT CUSTOMERCARE@SMTICKETS.COM",30,$y,552); 
	
			$y = $y + 10;
			$pdf->ColoredHeaderCell("THANK YOU FOR YOUR PURCHASE AND HOPE YOU ENJOY THE SHOW!",30,$y,552); 
			

			$pdf->normalText("",30,$y,'C');

		 	$y = $y + 15;
				$pdf->SetXY(30,$y);
				$pdf->SetFont('Arial','BI',5);
				$pdf->MultiCell(550,9," EFFECTIVE SEPTEMBER 9, ONLINE PURCHASE AND REDEMPTION WILL NO LONGER BE ALLOWED VIA REPRESENTATIVE. ONLY THE CARD HOLDER WHO TRANSACTED CAN REDEEMED THEIR TICKETS BOUGHT ONLINE. USER ACCOUNT NAME, VALID GOVERNMENT ID, CARD HOLDER NAME AND CARD NUMBER MUST BE IDENTICAL IN ORDER FOR US TO RELEASE YOUR TICKETS. THANK YOU FOR YOUR CONTINUED PATRONAGE.",'','L');
 



			
			
			







	$pdf->Output();
$pdf->Close();









